/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.tag.impl.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3494;
import net.minecraft.class_3695;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.resource.loader.api.reloader.SimpleResourceReloader;
import org.quiltmc.qsl.tag.impl.client.ClientTagRegistryManager;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
class ClientOnlyTagManagerReloader
implements SimpleResourceReloader<List<Entry>> {
    private static final class_2960 ID = new class_2960("quilt_tags", "client_only_tags");

    ClientOnlyTagManagerReloader() {
    }

    public class_2960 getQuiltId() {
        return ID;
    }

    public CompletableFuture<List<Entry>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList entries = new ArrayList();
            ClientTagRegistryManager.forEach(clientTagRegistryManager -> entries.add(new Entry((ClientTagRegistryManager<?>)clientTagRegistryManager, clientTagRegistryManager.load(manager))));
            return entries;
        }, executor);
    }

    public CompletableFuture<Void> apply(List<Entry> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> data.forEach(entry -> entry.manager().setSerializedTags(entry.serializedTags())), executor);
    }

    protected record Entry(ClientTagRegistryManager<?> manager, Map<class_2960, class_3494.class_3495> serializedTags) {
    }
}

